/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPen.h,v 1.3 1999/09/20 01:27:07 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPen_h	// [
#define Included_CPen_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CPen

class CPen
{
	NOT_COPYABLE(CPen)

public:
	CPen();
	CPen(HPEN pen);
	CPen(PGPInt32 penStyle, PGPInt32 width, COLORREF crColor);
	~CPen();

	CPen&	operator=(HPEN pen);

	operator HPEN() const {return mPen;}
	HPEN	Get() const {return mPen;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	void	Create(PGPInt32 penStyle, PGPInt32 width, COLORREF crColor);
	void	Attach(HPEN pen);
	void	Clear();

private:
	PGPBoolean	mWeCreated;
	HPEN		mPen;
};


// Class CPen member functions

inline 
CPen::CPen() : mWeCreated(FALSE), mPen(NULL)
{
}

inline 
CPen::CPen(HPEN pen) : mWeCreated(FALSE), mPen(NULL)
{
	Attach(pen);
}

inline 
CPen::CPen(PGPInt32 penStyle, PGPInt32 width, COLORREF crColor) : 
	mWeCreated(FALSE), mPen(NULL)
{
	Create(penStyle, width, crColor);
}

inline 
CPen::~CPen()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
CPen& 
CPen::operator=(HPEN pen)
{
	Attach(pen);
	return *this;
}

inline 
PGPBoolean 
CPen::IsAttached() const
{
	return IsntNull(mPen);
}

inline 
void 
CPen::Create(PGPInt32 penStyle, PGPInt32 width, COLORREF crColor)
{
	Clear();
	mPen = ::CreatePen(penStyle, width, crColor);

	if (IsNull(mPen))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

inline 
void 
CPen::Attach(HPEN pen)
{
	if (mPen == pen)
		return;

	Clear();

	mWeCreated = FALSE;
	mPen = pen;
}

inline 
void 
CPen::Clear()
{
	if (WeCreated())
		DeleteObject(mPen);

	mWeCreated = FALSE;
	mPen = NULL;
}

_PGP_END

#endif	// ] Included_CPen_h
